
// NOTE!! is the tristate SDA version...

//=============================================================================
//  RI2C SEND BYTE
//=============================================================================
void ri2c_send_byte(void)
{
	//----------------------------------------------------
	// this is a simple function that sends one i2c byte.
	// SCL is lo when we enter here.
	// SDA could be high or low, it doesn't matter.
	//
	// the data byte to be sent is in the global var 'data'
	//----------------------------------------------------

	ri2c_i = 8;			// 8 bits to send

send_ri2c_bit:			// send each bit
	if(data.F7)
	{
		RBTC_TRIS_SDA = 1;		// make SDA hi
	}
	else
	{
		RBTC_PIN_SDA = 0;		// make SDA low
		RBTC_TRIS_SDA = 0;
	}
	data = (data << 1);					// prep next bit
	asm goto $+1;
	asm goto $+1;

	RBTC_PIN_SCL = 1;		// SCL hi (make SCL pulse)
	asm goto $+1;
	RBTC_PIN_SCL = 0;		// SCL lo
	asm goto $+1;

	ri2c_i--;						// check if 8 bits sent yet
	if(ri2c_i) goto send_ri2c_bit;	// more bits left to send!

	//----------------------------------------------------
	// we sent 8 bits so let eeprom make an acknowlege bit

    RBTC_TRIS_SDA = 1;			// release SDA so eeprom can control it
	asm goto $+1;

	RBTC_PIN_SCL = 1;			// make SCL pulse so eeprom can ack
	asm goto $+1;

	//if(RBTC_PIN_SDA) error ++;  // test; lo=ack, hi=fail to ack error

	RBTC_PIN_SCL = 0;           // SCL lo to exit
	asm goto $+1;

	//exit with SCL lo, SDA unknown
	//----------------------------------------------------
}
//-----------------------------------------------------------------------------

//=============================================================================
//  RI2C RECEIVE BYTE
//=============================================================================
void ri2c_receive_byte(unsigned char ack_bit)
{
	//----------------------------------------------------
	// receives a byte from i2c eeprom
	// SCL is lo and SDA unknown when we enter
	//----------------------------------------------------

	RBTC_TRIS_SDA = 1;	// release SDA so eeprom controls it
	data = 0;			// data will hold the byte

	//----------------------------------------------------

	ri2c_i = 8;			// will get 8 bits

get_ri2c_bit:			// get each bit

	RBTC_PIN_SCL = 1;	// make SCL pulse
	asm goto $+1;

	data = (data << 1);		// move bits left ready for new bit
	if(RBTC_PIN_SDA) data++;	// get new bit from SDA, put in data.F0

	RBTC_PIN_SCL = 0;	// end of SCL pulse
	asm goto $+1;

	ri2c_i--;						// see if 8 bits received yet
	if(ri2c_i) goto get_ri2c_bit;	// more bits left to receive!

	//----------------------------------------------------
	// if we do an ack bit the eeprom will send us another data byte
	// the next time we do a read_byte. so we can just call this
	// read_byte function repeatedly so we can sequentially read an
	// entire eeprom contents.
	//----------------------------------------------------
	// now do the ack/no_ack bit

	if(ack_bit)
	{
		RBTC_PIN_SDA = 0;		// make an ack bit here
		RBTC_TRIS_SDA = 0;		//
	}
	asm goto $+1;

	RBTC_PIN_SCL = 1;		// make SCL pulse
	asm goto $+1;
	RBTC_PIN_SCL = 0;
	asm goto $+1;

	// exit with SCL lo, SDA unknown
	//----------------------------------------------------
}
//-----------------------------------------------------------------------------


//=============================================================================
//  RI2C START BIT
//=============================================================================
void ri2c_start_bit(void)
{
	//----------------------------------------------------
	// Start bit = SDA goes lo while SCL remains hi.
	//
	// if the i2c bus was free; SCL and SDA are both hi,
	// but if we just sent a byte; SCL is lo, SDA unknown
	//
	// so test if SDA is lo, if so; tidy up before start bit.
	//----------------------------------------------------
	// test if SCL is low and tidy up

	if(RBTC_PIN_SCL == 0)
	{
	    RBTC_TRIS_SDA = 1;		// release SDA, it should go hi
	    asm goto $+1;

	    RBTC_PIN_SCL = 1;		// SCL hi, SDA hi, ready to make start bit
	    asm goto $+1;
	}

	//----------------------------------------------------
	// now make the start bit

    RBTC_PIN_SDA = 0;		// this event is the \ start bit
    RBTC_TRIS_SDA = 0;		//
    asm goto $+1;
    RBTC_PIN_SCL = 0;		// SCL lo too
    asm goto $+1;

	// exit with SCL lo, SDA lo
	//----------------------------------------------------
}
//-----------------------------------------------------------------------------

//=============================================================================
//  RI2C STOP BIT
//=============================================================================
void ri2c_stop_bit(void)
{
	//----------------------------------------------------
	// Stop bit = SDA goes hi while SCL remains hi
	//
	// SCL is lo, SDA unknown when we enter
	//----------------------------------------------------

    RBTC_PIN_SDA = 0;		// if SDA hi, make SDA low first
    RBTC_TRIS_SDA = 0;		//
    asm goto $+1;

    RBTC_PIN_SCL = 1;		// SCL hi first
    asm goto $+1;
    RBTC_TRIS_SDA = 1;		// this is the / stop bit
    asm goto $+1;

	//----------------------------------------------------
}
//-----------------------------------------------------------------------------






